/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.common.util.HexDump;
import com.ibm.hsc.common.util.HscPrintStream;
import com.ibm.hsc.vterm.VSerialSystemInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class HardwareServerUtilities {
    public static final long HWS_ERROR_CODE_MASK = 0x100000000000000L;
    public static final long FSP_ERROR_CODE_MASK = 0x200000000000000L;
    public static final long FSP_PARSE_ERROR_MASK = 0x300000000000000L;
    private String m_hdwrSvrIpAddress;
    private Socket m_hdwrSvrSocket;
    private InputStream m_socketInput;
    private DataOutputStream m_socketOutput;
    private static int m_hsCorrToken = 1;
    private static final int NONE = 0;
    private static final int LISTCECS = 7;

    public static void main(String[] stringArray) {
        String string = "localhost";
        int n = 0;
        Object var3_3 = null;
        if (stringArray.length == 0) {
            HardwareServerUtilities.printHelp(null);
            System.exit(0);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("args[" + i + "] = '" + stringArray[i] + "'");
            if ("-hwsip".equalsIgnoreCase(stringArray[i])) {
                if (i + 1 >= stringArray.length) {
                    HardwareServerUtilities.printHelp("Error: -hwsip needs a parm");
                }
                string = stringArray[++i];
                continue;
            }
            if (!"-listcecs".equalsIgnoreCase(stringArray[i])) continue;
            n = 7;
            try {
                HardwareServerUtilities hardwareServerUtilities = new HardwareServerUtilities(string);
                VSerialSystemInfo[] vSerialSystemInfoArray = hardwareServerUtilities.listCECs();
                if (vSerialSystemInfoArray == null || vSerialSystemInfoArray.length == 0) {
                    System.out.println("no fsps found");
                    continue;
                }
                for (int j = 0; j < vSerialSystemInfoArray.length; ++j) {
                    System.out.println("fsp[" + j + "]=" + vSerialSystemInfoArray[j]);
                }
                continue;
            }
            catch (IOException iOException) {
                System.err.println("HardwareServerUtilities main IOException: " + iOException);
                iOException.printStackTrace();
            }
        }
        System.out.println("done");
        System.exit(0);
    }

    private static void printHelp(String string) {
        if (string != null) {
            System.out.println("******************************************************");
            System.out.println("* " + string);
            System.out.println("******************************************************");
        }
        System.out.println("Usage: HardwareServerUtilities");
        System.out.println("  -hwsip hwsipaddr");
        System.out.println("     hwsipaddr = the ip of the HMC hardware server (default is localhost)");
        System.out.println("  [-listcecs]");
        System.out.println("      get a list of fsps with vport and mtms");
        if (string != null) {
            System.out.println("******************************************************");
            System.out.println("* " + string);
            System.out.println("******************************************************");
        }
        System.exit(1);
    }

    public HardwareServerUtilities(String string) throws IOException {
        this.m_hdwrSvrIpAddress = string;
    }

    public void connect() throws IOException {
        this.m_hdwrSvrSocket = new Socket(this.m_hdwrSvrIpAddress, 8877);
        this.m_socketInput = this.m_hdwrSvrSocket.getInputStream();
        this.m_socketOutput = new DataOutputStream(this.m_hdwrSvrSocket.getOutputStream());
    }

    public VSerialSystemInfo getSystemInfoFromKey(String string) throws IOException {
        if (string == null) {
            return null;
        }
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        VSerialSystemInfo[] vSerialSystemInfoArray = this.listCECs();
        if (n >= 0) {
            for (int i = 0; i < vSerialSystemInfoArray.length; ++i) {
                if (n != vSerialSystemInfoArray[i].m_hardware_server_vport && n != vSerialSystemInfoArray[i].m_hardware_server_vport_tty) continue;
                return vSerialSystemInfoArray[i];
            }
        } else {
            for (int i = 0; i < vSerialSystemInfoArray.length; ++i) {
                if (!string.equalsIgnoreCase(vSerialSystemInfoArray[i].m_type_model_serial)) continue;
                return vSerialSystemInfoArray[i];
            }
        }
        return null;
    }

    public VSerialSystemInfo[] listCECs() throws IOException {
        HardwareServerMessage hardwareServerMessage;
        HardwareServerMessage hardwareServerMessage2;
        if (this.m_hdwrSvrSocket == null) {
            this.connect();
        }
        if ((hardwareServerMessage2 = this.sendAndRecieve(hardwareServerMessage = HardwareServerMessage.buildHSFspQuery())).isHSError()) {
            throw new IOException("Error communicating with hardware server: HS Response RC = 0x" + Integer.toHexString(hardwareServerMessage2.getErrorCode()));
        }
        byte[] byArray = hardwareServerMessage2.getPayload();
        int[] nArray = new int[byArray.length / 4];
        if (nArray.length == 0) {
            return null;
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = HardwareServerMessage.bytesToUInt(byArray, i * 4);
        }
        VSerialSystemInfo[] vSerialSystemInfoArray = new VSerialSystemInfo[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            hardwareServerMessage = HardwareServerMessage.buildFspDataQuery(nArray[i]);
            hardwareServerMessage2 = this.sendAndRecieve(hardwareServerMessage);
            if (hardwareServerMessage2.isHSError()) {
                System.err.println("HS Response vport[" + nArray[i] + "] RC = 0x" + Integer.toHexString(hardwareServerMessage2.getErrorCode()));
                continue;
            }
            byArray = hardwareServerMessage2.getPayload();
            int n2 = HardwareServerMessage.bytesToUShort(byArray, 0);
            String string = "";
            int n3 = 1;
            if (n2 >= 24) {
                n = HardwareServerMessage.bytesToUShort(byArray, 4);
                int n4 = HardwareServerMessage.bytesToUShort(byArray, 6);
                int n5 = HardwareServerMessage.bytesToUShort(byArray, 8);
                int n6 = HardwareServerMessage.bytesToUShort(byArray, 10);
                int n7 = HardwareServerMessage.bytesToUInt(byArray, 12);
                int n8 = HardwareServerMessage.bytesToUShort(byArray, 16);
                int n9 = HardwareServerMessage.bytesToUShort(byArray, 18);
                String string2 = new String(byArray, 20, 2);
                int n10 = HardwareServerMessage.bytesToUShort(byArray, 22);
                String string3 = new String(byArray, 24, n10 - 1);
                int n11 = HardwareServerMessage.bytesToUShort(byArray, 24 + n10);
                n3 = HardwareServerMessage.bytesToUShort(byArray, n2 + n11 + 32);
                if (n11 > 0) {
                    int n12 = 26 + n10;
                    String string4 = new String(byArray, n12, n11 - 1);
                }
            }
            for (n = n2; n < byArray.length; ++n) {
                if (byArray[n] != 0) continue;
                string = new String(byArray, n2, n - n2);
                break;
            }
            vSerialSystemInfoArray[i] = new VSerialSystemInfo(string, "TODO:", 0, nArray[i], nArray[i] + 1, n3);
        }
        return vSerialSystemInfoArray;
    }

    public static HardwareServerMessage buildFspRequestMsg(int n, int n2, int n3, byte[] byArray) {
        return HardwareServerUtilities.buildFspRequestMsg(n, n2, n3, m_hsCorrToken++, byArray);
    }

    public static HardwareServerMessage buildFspRequestMsg(int n, int n2, int n3, int n4, byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        try {
            int n5 = byArray.length >= 16 ? 0 : 16 - byArray.length;
            int n6 = 24 + byArray.length + n5;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(-557121792);
            dataOutputStream.writeInt(n6);
            dataOutputStream.writeInt(n4);
            dataOutputStream.writeShort(n2);
            dataOutputStream.writeByte(n2 >= 32768 ? 128 : 8);
            dataOutputStream.writeByte(n5);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeShort(n3);
            dataOutputStream.writeShort(0);
            dataOutputStream.write(byArray);
            for (int i = 0; i < n5; ++i) {
                dataOutputStream.writeByte(0);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return HardwareServerMessage.buildFspPassthrough(n, n4, byArray2);
        }
        catch (IOException iOException) {
            System.err.println("Error building request message: " + iOException);
            return null;
        }
    }

    public static FspMessageLight getFspPassthroughResponseErrorCode(HardwareServerMessage hardwareServerMessage) {
        FspMessageLight fspMessageLight = new FspMessageLight();
        if (hardwareServerMessage.isHSError() || hardwareServerMessage.getMajorOpCode() == 80 && hardwareServerMessage.getMinorOpCode() == 98) {
            fspMessageLight.parsingerror = 0x100000000000000L | (long)hardwareServerMessage.getErrorCode();
            return fspMessageLight;
        }
        if (hardwareServerMessage.getMajorOpCode() != 80 || hardwareServerMessage.getMinorOpCode() != 97) {
            fspMessageLight.parsingerror = 0x100000000000000L;
            return fspMessageLight;
        }
        byte[] byArray = hardwareServerMessage.getPayload();
        if (byArray.length < 40) {
            fspMessageLight.parsingerror = 0x300000000000000L;
            return fspMessageLight;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n = dataInputStream.readInt();
            if (n != -557121792) {
                fspMessageLight.parsingerror = 0x300000000000000L;
                return fspMessageLight;
            }
            int n2 = dataInputStream.readInt();
            fspMessageLight.correlationtoken = dataInputStream.readInt() & 0xFFFFFFFF;
            fspMessageLight.target = dataInputStream.readShort() & 0xFFFF;
            fspMessageLight.flags = dataInputStream.readByte() & 0xFF;
            int n3 = dataInputStream.readByte() & 0xFF;
            dataInputStream.readInt();
            fspMessageLight.opcode = dataInputStream.readShort() & 0xFFFF;
            fspMessageLight.status = dataInputStream.readShort() & 0xFFFF;
            fspMessageLight.payload = new byte[n2 - n3 - 24];
            System.arraycopy(byArray, 24, fspMessageLight.payload, 0, fspMessageLight.payload.length);
        }
        catch (IOException iOException) {
            fspMessageLight.parsingerror = 0x300000000000000L;
            return fspMessageLight;
        }
        return fspMessageLight;
    }

    private HardwareServerMessage sendAndRecieve(HardwareServerMessage hardwareServerMessage) throws IOException {
        this.m_socketOutput.write(hardwareServerMessage.toBytes());
        return new HardwareServerMessage(this.m_socketInput);
    }

    public static class FspMessageLight {
        public long parsingerror;
        public int opcode;
        public int target;
        public int status;
        public int correlationtoken;
        public int flags;
        public byte[] payload;

        public String toString() {
            String string = HscPrintStream.isTraceActive() ? new HexDump(this.payload).toString() : "";
            return "tg,op,ct,st,pe=0x" + Integer.toHexString(this.target) + ",0x" + Integer.toHexString(this.opcode) + ",0x" + Integer.toHexString(this.correlationtoken) + ",0x" + Integer.toHexString(this.status) + ",0x" + Long.toHexString(this.parsingerror) + "  payload:" + string;
        }
    }
}

